﻿using RX_Sample._00_API;
using RX_Sample._03_ReactiveX;
using System;

namespace RX_Sample._04_Final.Conctact
{
    class ContactModel : IContactModel
    {
        private readonly IContact contact;

        public ContactModel(IContact contact)
        {
            this.contact = contact;
            Avatar = contact
                .FromPropertyAndEvent<IContact, byte[], byte[]>(
                    c => c.Avatar,
                    (c, handler) => c.AvatarChanged += handler,
                    (c, handler) => c.AvatarChanged -= handler);
        }

        public string ContactId => contact.ContactId;

        public IObservable<byte[]> Avatar { get; }
    }
}
