﻿using System;
using System.Linq;
using System.Reactive.Linq;
using System.Threading.Tasks;

namespace RX_Sample._03_ReactiveX
{
    class Sample02
    {
        public Sample02()
        {
            Observable.Empty<int>();

            Observable.Return(1);

            Observable.Start(() => DateTime.Now);

            Observable.FromAsync(() => Task.Delay(TimeSpan.FromSeconds(20)));

            Enumerable
                .Range(1, 10)
                .ToObservable();

            var eventSource = new EventSource();

            Observable
                .FromEvent<EventHandler<int>, int>(
                    action => (sender, value) => action(value),
                    handler => eventSource.SomeEvent += handler,
                    handler => eventSource.SomeEvent -= handler);
        }

        class EventSource
        {
            public event EventHandler<int> SomeEvent;
        }
    }
}
