﻿using System;
using System.Threading.Tasks;

namespace RX_Sample._02_Mediator
{
    public class NotificationAreaViewModel : IDisposable
    {
        private readonly IMediator mediator;

        public NotificationAreaViewModel(
            IMediator mediator,
            IDispatcher dispatcher)
        {
            mediator.RegisterWithDispatcher<CollaborationMessage>(dispatcher, this, CollaborationMessageHandler);
            this.mediator = mediator;
        }

        public bool IsCollaborationActive { get; set; }

        private async void CollaborationMessageHandler(CollaborationMessage collaborationMessage)
        {
            if (!collaborationMessage.IsCollaborationActive)
            {
                return;
            }

            IsCollaborationActive = true;
            await Task.Delay(TimeSpan.FromSeconds(7));
            IsCollaborationActive = false;
        }

        public void Dispose()
        {
            mediator.UnRegister<CollaborationMessage>(this);
        }
    }
}
