﻿using System;

namespace RX_Sample._02_Mediator
{
    public static class MediatorExtensions
    {
        public static void RegisterWithDispatcher<TMessage>(this IMediator mediator, IDispatcher dispatcher, object subject, Action<TMessage> handler, object key = null)
        {
            mediator.Register<TMessage>(subject, message => dispatcher.Dispatch(() => handler(message)), key);
        }
    }
}
