﻿
using RX_Sample._00_API;
using System;
using System.Threading.Tasks;

namespace RX_Sample.Naive
{
    public sealed class NotificationAreaViewModel : IDisposable
    {
        private readonly IAppCallService callService;
        private readonly IDispatcher dispatcher;

        public NotificationAreaViewModel(
            IAppCallService callService,
            IDispatcher dispatcher)
        {
            callService.CallStarted += OnCallCreated;
            callService.IncommingCall += OnCallCreated;
            callService.CallEnded += OnCallEnded;
            this.callService = callService;
            this.dispatcher = dispatcher;
        }

        public bool IsCollaborationActive { get; set; }

        private void OnCallCreated(object sender, ICall call)
        {
            call.CollaborationStarted += OnCollaborationStarted;
        }

        private void OnCallEnded(object sender, ICall call)
        {
            call.CollaborationStarted -= OnCollaborationStarted;
        }

        private void OnCollaborationStarted(object sender, ICollaboration e)
        {
            dispatcher.Dispatch(OnCollaborationStartedUIThread);
        }

        private async void OnCollaborationStartedUIThread()
        {
            IsCollaborationActive = true;
            await Task.Delay(TimeSpan.FromSeconds(7));
            IsCollaborationActive = false;
        }

        public void Dispose()
        {
            callService.CallStarted -= OnCallCreated;
            callService.IncommingCall -= OnCallCreated;
            callService.CallEnded -= OnCallEnded;
        }
    }
}
