﻿using System;
using System.Threading.Tasks;

namespace RX_Sample._00_API
{
    public interface ICall : IDisposable
    {
        int CallId { get; }

        CallStatus CallStatus { get; }

        ICollaboration Collaboration { get; }

        string ContactId { get; }

        Task End();

        event EventHandler<ICollaboration> CollaborationStarted;

        event EventHandler<ICollaboration> CollaborationEnded;

        event EventHandler<CallStatus> CallStatusChanged;

        event EventHandler<string> ContactIdChanged;
    }
}
